/**
 * Copyright (c) 2009 - Lehigh University. Bethlehem, PA, USA.
 * All rights reserved.
 * This source code is a part of MARCHES Project. 
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs, and the author attribution appear in all copies of this
 * software.
 *
 * IN NO EVENT SHALL LEHIGH UNIVERSITY BE LIABLE TO ANY PARTY FOR DIRECT, 
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF LEHIGH
 * UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *	
 * LEHIGH UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, 
 * AND LEHIGH UNIVERSITY HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 **/

// modsDlg.cpp : implementation file
//

using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.Collections;
using System.Runtime.InteropServices;

namespace MassWare
{
    [Serializable]
    public class SyncRequest //private, public for X.doc generation
    {
        [Serializable]
        public struct RequestPair
        {
            public byte m_idProActuator;
            public List<MassWare.MassletReflectObject> m_CompntList;
            public byte m_type; //0 for sync, 1 for async

            public byte[] ToByteArray()
            {
                byte[] ret = new byte[MassWare.MAXIMUMARRAYSIZE];

                ret[0] = m_idProActuator;
                ret[1] = m_type;
                
                int idx = 2;
                Int32 len;
                byte[] barlen, bardt;

                Int32 num = m_CompntList.Count;
                bardt = BitConverter.GetBytes(num);
                bardt.CopyTo(ret, idx);
                idx += bardt.Length;

                for (int i = 0; i < num; i++)
                {
                    bardt = m_CompntList[i].ToByteArray();

                    // save length of next component
                    len = bardt.Length;
                    barlen = BitConverter.GetBytes(len);
                    barlen.CopyTo(ret, idx);
                    idx += barlen.Length;

                    // save data of next component
                    bardt.CopyTo(ret, idx);
                    idx += bardt.Length;
                }
                byte[] res = new byte[idx];
                Array.Copy(ret, res, idx);
                return res;
            }

            public void FromByteArray(byte[] dt)
            {
                int NUMLEN = sizeof(Int32); // Int32 has four bytes
                m_idProActuator = dt[0];
                m_type = dt[1];

                int idx = 2;
                byte[] barlen, bardt;
                Int32 len;

                barlen = new byte[NUMLEN];
                Array.Copy(dt, idx, barlen, 0, NUMLEN);
                idx += NUMLEN;

                Int32 num = BitConverter.ToInt32(barlen, 0);

                m_CompntList = new List<MassWare.MassletReflectObject>(num);

                for (int i = 0; i < num; i++)
                {
                    MassWare.MassletReflectObject ro = new MassWare.MassletReflectObject();

                    // get the length
                    Array.Copy(dt, idx, barlen, 0, NUMLEN);
                    idx += NUMLEN;
                    len = BitConverter.ToInt32(barlen, 0);

                    // get the data 
                    bardt = new byte[len];
                    Array.Copy(dt, idx, bardt, 0, len);
                    idx += len;
                    ro.FromByteArray(bardt);

                    m_CompntList.Add(ro);
                }

                if (idx != dt.Length) throw new Exception("sync request packet error");
            }
        }

        List<RequestPair> mRequestPacket;

        public SyncRequest()
        {
            mRequestPacket = new List<RequestPair>();
        }

        public void Add(byte id, List<MassWare.MassletReflectObject> list)
        {
        }

        public void Add(byte id, Actuator act)
        {
            Add(id, act.mActuator, act.mSyncType);
        }

        public void Add(byte id, List<MassWare.MassletReflectObject> list, Actuator.SYNCTYPE type)
        {
            RequestPair pair;
            pair.m_idProActuator = id;
            pair.m_CompntList = list;
            pair.m_type = (byte)type;
            mRequestPacket.Add(pair);
        }

        public List<RequestPair> mPacket
        {
            get
            {
                return mRequestPacket;
            }
        }

        public byte[] Serialize()
        {
            MemoryStream ms = new MemoryStream();
            BinaryFormatter bFormatter = new BinaryFormatter();
            bFormatter.Serialize(ms, this);
            return ms.ToArray();
        }

        public byte[] ToByteArray()
        {
            byte[] ret = new byte[MassWare.MAXIMUMARRAYSIZE];
            int idx = 0;

            Int32 len;
            byte[] barlen, bardt;

            Int32 num = mRequestPacket.Count;
            bardt = BitConverter.GetBytes(num);
            bardt.CopyTo(ret, idx);
            idx += bardt.Length;

            for (int i = 0; i < num; i++)
            {
                bardt = mRequestPacket[i].ToByteArray();

                // save length of next request pair
                len = bardt.Length;
                barlen = BitConverter.GetBytes(len);
                barlen.CopyTo(ret, idx);
                idx += barlen.Length;

                // save data of next request piar
                bardt.CopyTo(ret, idx);
                idx += bardt.Length;
            }
            byte[] res = new byte[idx];
            Array.Copy(ret, res, idx);
            return res;
        }

        public static SyncRequest DeSerialize(byte[] dt)
        {
            MemoryStream ms = new MemoryStream(dt);
            BinaryFormatter bFormatter = new BinaryFormatter();
            SyncRequest retVal = (SyncRequest)bFormatter.Deserialize(ms);
            return retVal;
        }

        public static SyncRequest FromByteArray(byte[] dt)
        {
            SyncRequest sr = new SyncRequest();

            int NUMLEN = sizeof(Int32); // Int32 has four bytes
            int idx = 0;

            byte[] barlen, bardt;
            Int32 len;

            barlen = new byte[NUMLEN];
            Array.Copy(dt, idx, barlen, 0, NUMLEN);
            idx += NUMLEN;

            Int32 num = BitConverter.ToInt32(barlen, 0);

            for (int i = 0; i < num; i++)
            {
                RequestPair rp = new RequestPair();

                // get the length
                Array.Copy(dt, idx, barlen, 0, NUMLEN);
                idx += NUMLEN;
                len = BitConverter.ToInt32(barlen, 0);

                // get the data 
                bardt = new byte[len];
                Array.Copy(dt, idx, bardt, 0, len);
                idx += len;
                rp.FromByteArray(bardt);

                sr.mPacket.Add(rp);
            }

            if (idx != dt.Length) throw new Exception("sync request packet error");
            return sr;
        }

        public void Dispose()
        {
            mRequestPacket.Clear();
        }
    }
}
