/**
 * Copyright (c) 2009 - Lehigh University. Bethlehem, PA, USA.
 * All rights reserved.
 * This source code is a part of MARCHES Project. 
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs, and the author attribution appear in all copies of this
 * software.
 *
 * IN NO EVENT SHALL LEHIGH UNIVERSITY BE LIABLE TO ANY PARTY FOR DIRECT, 
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF LEHIGH
 * UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *	
 * LEHIGH UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, 
 * AND LEHIGH UNIVERSITY HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 **/

// modsDlg.cpp : implementation file
//

using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;

namespace MassWare
{
    [Serializable]
    public class SyncReply //private, public for X.doc generation
    {
        [Serializable]
        public struct ReplyPair
        {
            public byte m_idProActuator;
            public byte m_idSyncAcutator;

            public byte[] ToByteArray()
            {
                byte[] res = new byte[2];
                res[0] = m_idProActuator;
                res[1] = m_idSyncAcutator;
                return res;
            }

            public void FromByteArray(byte[] dt)
            {
                m_idProActuator = dt[0];
                m_idSyncAcutator = dt[1];
            }
        }

        List<ReplyPair> mReplyPacket;

        public SyncReply()
        {
            mReplyPacket = new List<ReplyPair>();
        }

        public void Add(byte id, byte sid)
        {
            ReplyPair pair;
            pair.m_idProActuator = id;
            pair.m_idSyncAcutator = sid;
            mReplyPacket.Add(pair);
        }

        public List<ReplyPair> mPacket
        {
            get
            {
                return mReplyPacket;
            }
        }

        public byte[] Serialize()
        {
            MemoryStream ms = new MemoryStream();
            BinaryFormatter bFormatter = new BinaryFormatter();
            bFormatter.Serialize(ms, this);
            return ms.ToArray();
        }

        public byte[] ToByteArray()
        {
            byte[] ret = new byte[MassWare.MAXIMUMARRAYSIZE];
            int idx = 0;

            Int32 len;
            byte[] barlen, bardt;

            Int32 num = mReplyPacket.Count;
            bardt = BitConverter.GetBytes(num);
            bardt.CopyTo(ret, idx);
            idx += bardt.Length;

            for (int i = 0; i < num; i++)
            {
                bardt = mReplyPacket[i].ToByteArray();

                // save length of next request pair
                len = bardt.Length;
                barlen = BitConverter.GetBytes(len);
                barlen.CopyTo(ret, idx);
                idx += barlen.Length;

                // save data of next request piar
                bardt.CopyTo(ret, idx);
                idx += bardt.Length;
            }
            byte[] res = new byte[idx];
            Array.Copy(ret, res, idx);
            return res;
        }

        public static SyncReply DeSerialize(byte[] dt)
        {
            MemoryStream ms = new MemoryStream(dt);
            BinaryFormatter bFormatter = new BinaryFormatter();
            SyncReply retVal = (SyncReply)bFormatter.Deserialize(ms);
            return retVal;
        }

        public static SyncReply FromByteArray(byte[] dt)
        {
            SyncReply sr = new SyncReply();

            int NUMLEN = sizeof(Int32); // Int32 has four bytes
            int idx = 0;

            byte[] barlen, bardt;
            Int32 len;

            barlen = new byte[NUMLEN];
            Array.Copy(dt, idx, barlen, 0, NUMLEN);
            idx += NUMLEN;

            Int32 num = BitConverter.ToInt32(barlen, 0);

            for (int i = 0; i < num; i++)
            {
                ReplyPair rp = new ReplyPair();

                // get the length
                Array.Copy(dt, idx, barlen, 0, NUMLEN);
                idx += NUMLEN;
                len = BitConverter.ToInt32(barlen, 0);

                // get the data 
                bardt = new byte[len];
                Array.Copy(dt, idx, bardt, 0, len);
                idx += len;
                rp.FromByteArray(bardt);

                sr.mPacket.Add(rp);
            }

            if (idx != dt.Length) throw new Exception("sync request packet error");
            return sr;
        }
    }
}
