/**
 * Copyright (c) 2009 - Lehigh University. Bethlehem, PA, USA.
 * All rights reserved.
 * This source code is a part of MARCHES Project. 
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs, and the author attribution appear in all copies of this
 * software.
 *
 * IN NO EVENT SHALL LEHIGH UNIVERSITY BE LIABLE TO ANY PARTY FOR DIRECT, 
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF LEHIGH
 * UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *	
 * LEHIGH UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, 
 * AND LEHIGH UNIVERSITY HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 **/

// modsDlg.cpp : implementation file
//

using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;
using System.Net;
using System.Net.Sockets;

namespace MassWare
{
    public class MassWare
    {
        #region variables

        public const int MAXIMUMARRAYSIZE = 65535;

        [Serializable]
        public struct ParamObject
        {
            public string type;
            public string value;

            public byte[] ToByteArray()
            {
                byte[] bar1, bar2;
                if (type != null) bar1 = Encoding.ASCII.GetBytes(type);
                else bar1 = new byte[0];

                if (value != null) bar2 = Encoding.ASCII.GetBytes(value);
                else bar2 = new byte[0];

                Int32 len1 = bar1.Length;
                Int32 len2 = bar2.Length;

                byte[] barlen1 = BitConverter.GetBytes(len1);
                byte[] barlen2 = BitConverter.GetBytes(len2);

                byte[] res = new byte[barlen1.Length + len1 + barlen2.Length + len2];
                barlen1.CopyTo(res, 0);
                bar1.CopyTo(res, barlen1.Length);
                barlen2.CopyTo(res, barlen1.Length + bar1.Length);
                bar2.CopyTo(res, barlen1.Length + bar1.Length + barlen2.Length);

                return res;
            }

            public void FromByteArray(byte[] dt)
            {
                int NUMLEN = sizeof(Int32); // Int32 has four bytes
                int idx = 0;

                byte[] barlen = new byte[NUMLEN];                
                Array.Copy(dt, idx, barlen, 0, NUMLEN);
                idx += NUMLEN;
                Int32 len = BitConverter.ToInt32(barlen, 0);

                if (len > 0)
                {
                    byte[] bardt = new byte[len];
                    Array.Copy(dt, idx, bardt, 0, len);
                    idx += len;
                    type = Encoding.ASCII.GetString(bardt);
                }

                Array.Copy(dt, idx, barlen, 0, NUMLEN);
                idx += NUMLEN;
                len = BitConverter.ToInt32(barlen, 0);

                if (len > 0)
                {
                    byte[] bardt = new byte[len];
                    Array.Copy(dt, idx, bardt, 0, len);
                    idx += len;
                    value = Encoding.ASCII.GetString(bardt);
                }
            }
        }

        public struct MassToolReflectObject
        {
            public string name; // for set application parameter
            public Type type;
            public Object obj;
            public string outfunc; // add subscriber
        }

        [Serializable]
        public struct Connector
        {
            public string interf; // the interface to connect that componneet 
            public string func; // the function for get or add subscriber

            public byte[] ToByteArray()
            {
                byte[] bar1, bar2;
                if (interf != null) bar1 = Encoding.ASCII.GetBytes(interf);
                else bar1 = new byte[0];

                if (func != null) bar2 = Encoding.ASCII.GetBytes(func);
                else bar2 = new byte[0];

                Int32 len1 = bar1.Length;
                Int32 len2 = bar2.Length;

                byte[] barlen1 = BitConverter.GetBytes(len1);
                byte[] barlen2 = BitConverter.GetBytes(len2);

                byte[] res = new byte[barlen1.Length + len1 + barlen2.Length + len2];
                barlen1.CopyTo(res, 0);
                bar1.CopyTo(res, barlen1.Length);
                barlen2.CopyTo(res, barlen1.Length + bar1.Length);
                bar2.CopyTo(res, barlen1.Length + bar1.Length + barlen2.Length);

                return res;
            }

            public void FromByteArray(byte[] dt)
            {
                int NUMLEN = sizeof(Int32); // Int32 has four bytes
                int idx = 0;

                byte[] barlen = new byte[NUMLEN];
                Array.Copy(dt, idx, barlen, 0, NUMLEN);
                idx += NUMLEN;
                Int32 len = BitConverter.ToInt32(barlen, 0);

                if (len > 0)
                {
                    byte[] bardt = new byte[len];
                    Array.Copy(dt, idx, bardt, 0, len);
                    idx += len;
                    interf = Encoding.ASCII.GetString(bardt);
                }

                Array.Copy(dt, idx, barlen, 0, NUMLEN);
                idx += NUMLEN;
                len = BitConverter.ToInt32(barlen, 0);

                if (len > 0)
                {
                    byte[] bardt = new byte[len];
                    Array.Copy(dt, idx, bardt, 0, len);
                    idx += len;
                    func = Encoding.ASCII.GetString(bardt);
                }
            }
        }

        [Serializable]
        public struct MassletReflectObject
        {
            public string name; // for serialization
            public Type type;
            public Object obj;
            public Hashtable tbInput;
            public Hashtable tbOutput;
            public Hashtable tbparam;

            public byte[] ToByteArray()
            {
                byte[] ret = new byte[MAXIMUMARRAYSIZE];

                int idx = 0;
                Int32 len, num;
                byte[] barlen, bardt;
                IDictionaryEnumerator _enumerator;

                bardt = Encoding.ASCII.GetBytes(name); 

                // save length of name
                len = bardt.Length;
                barlen = BitConverter.GetBytes(len);
                barlen.CopyTo(ret, idx);
                idx += barlen.Length;

                // save data of name
                bardt.CopyTo(ret, idx);
                idx += bardt.Length;

                // save the input interface hash table
                num = tbInput.Count;
                bardt = BitConverter.GetBytes(num);
                bardt.CopyTo(ret, idx);
                idx += bardt.Length;

                _enumerator = tbInput.GetEnumerator();
                while (_enumerator.MoveNext())
                {
                    // get input name data
                    bardt = Encoding.ASCII.GetBytes((string)_enumerator.Key);
                    len = bardt.Length;

                    // set the lenght of the name
                    barlen = BitConverter.GetBytes(len);
                    barlen.CopyTo(ret, idx);
                    idx += barlen.Length;

                    // set the data of the name
                    bardt.CopyTo(ret, idx);
                    idx += bardt.Length;

                    // get input value data
                    bardt = ((MassWare.Connector)_enumerator.Value).ToByteArray();
                    len = bardt.Length;

                    // set the length of the value
                    barlen = BitConverter.GetBytes(len);
                    barlen.CopyTo(ret, idx);
                    idx += barlen.Length;

                    // set the data of the value
                    bardt.CopyTo(ret, idx);
                    idx += bardt.Length;
                }

                // save the output interface hash table
                num = tbOutput.Count;
                bardt = BitConverter.GetBytes(num);
                bardt.CopyTo(ret, idx);
                idx += bardt.Length;

                _enumerator = tbOutput.GetEnumerator();
                while (_enumerator.MoveNext())
                {
                    // get output name data
                    bardt = Encoding.ASCII.GetBytes((string)_enumerator.Key);
                    len = bardt.Length;

                    // set the lenght of the name
                    barlen = BitConverter.GetBytes(len);
                    barlen.CopyTo(ret, idx);
                    idx += barlen.Length;

                    // set the data of the name
                    bardt.CopyTo(ret, idx);
                    idx += bardt.Length;

                    // get output value data
                    bardt = ((MassWare.Connector)_enumerator.Value).ToByteArray();
                    len = bardt.Length;

                    // set the length of the value
                    barlen = BitConverter.GetBytes(len);
                    barlen.CopyTo(ret, idx);
                    idx += barlen.Length;

                    // set the data of the value
                    bardt.CopyTo(ret, idx);
                    idx += bardt.Length;
                }

                // save the parameter hash table
                num = tbparam.Count;
                bardt = BitConverter.GetBytes(num);
                bardt.CopyTo(ret, idx);
                idx += bardt.Length;

                _enumerator = tbparam.GetEnumerator();
                while (_enumerator.MoveNext())
                {
                    // get parameter name data
                    bardt = Encoding.ASCII.GetBytes((string)_enumerator.Key);
                    len = bardt.Length;

                    // set the lenght of the name
                    barlen = BitConverter.GetBytes(len);
                    barlen.CopyTo(ret, idx);
                    idx += barlen.Length;

                    // set the data of the name
                    bardt.CopyTo(ret, idx);
                    idx += bardt.Length;

                    // get parameter value data
                    bardt = ((MassWare.ParamObject)_enumerator.Value).ToByteArray();
                    len = bardt.Length;

                    // set the length of the value
                    barlen = BitConverter.GetBytes(len);
                    barlen.CopyTo(ret, idx);
                    idx += barlen.Length;

                    // set the data of the value
                    bardt.CopyTo(ret, idx);
                    idx += bardt.Length;
                }

                byte[] res = new byte[idx];
                Array.Copy(ret, res, idx);
                return res;
            }

            public void FromByteArray(byte[] dt)
            {
                int NUMLEN = sizeof(Int32); // Int32 has four bytes

                int idx = 0;
                byte[] barlen, bardt;
                Int32 len, num;

                // get the length of the name
                barlen = new byte[NUMLEN];
                Array.Copy(dt, idx, barlen, 0, NUMLEN);
                idx += NUMLEN;
                len = BitConverter.ToInt32(barlen, 0);

                // get the name
                bardt = new byte[len];
                Array.Copy(dt, idx, bardt, 0, len);
                idx += len;
                name = Encoding.ASCII.GetString(bardt);

                // get input interface information
                Array.Copy(dt, idx, barlen, 0, NUMLEN);
                idx += NUMLEN;
                num = BitConverter.ToInt32(barlen, 0);

                tbInput = new Hashtable(num);
                for (int i = 0; i < num; i++)
                {
                    // get length of the name
                    Array.Copy(dt, idx, barlen, 0, NUMLEN);
                    idx += NUMLEN;
                    len = BitConverter.ToInt32(barlen, 0);

                    // get the name
                    bardt = new byte[len];
                    Array.Copy(dt, idx, bardt, 0, len);
                    idx += len;
                    string tbname = Encoding.ASCII.GetString(bardt);

                    // get the length of the value
                    Array.Copy(dt, idx, barlen, 0, NUMLEN);
                    idx += NUMLEN;
                    len = BitConverter.ToInt32(barlen, 0);

                    // get the value
                    bardt = new byte[len];
                    Array.Copy(dt, idx, bardt, 0, len);
                    idx += len;
                    Connector tbvalue = new Connector();
                    tbvalue.FromByteArray(bardt);

                    tbInput.Add(tbname, tbvalue);
                }

                // get output interface information
                Array.Copy(dt, idx, barlen, 0, NUMLEN);
                idx += NUMLEN;
                num = BitConverter.ToInt32(barlen, 0);

                tbOutput = new Hashtable(num);
                for (int i = 0; i < num; i++)
                {
                    // get length of the name
                    Array.Copy(dt, idx, barlen, 0, NUMLEN);
                    idx += NUMLEN;
                    len = BitConverter.ToInt32(barlen, 0);

                    // get the name
                    bardt = new byte[len];
                    Array.Copy(dt, idx, bardt, 0, len);
                    idx += len;
                    string tbname = Encoding.ASCII.GetString(bardt);

                    // get the length of the value
                    Array.Copy(dt, idx, barlen, 0, NUMLEN);
                    idx += NUMLEN;
                    len = BitConverter.ToInt32(barlen, 0);

                    // get the value
                    bardt = new byte[len];
                    Array.Copy(dt, idx, bardt, 0, len);
                    idx += len;
                    Connector tbvalue = new Connector();
                    tbvalue.FromByteArray(bardt);

                    tbOutput.Add(tbname, tbvalue);
                }

                // get parameter interface information
                Array.Copy(dt, idx, barlen, 0, NUMLEN);
                idx += NUMLEN;
                num = BitConverter.ToInt32(barlen, 0);

                tbparam = new Hashtable(num);
                for (int i = 0; i < num; i++)
                {
                    // get length of the name
                    Array.Copy(dt, idx, barlen, 0, NUMLEN);
                    idx += NUMLEN;
                    len = BitConverter.ToInt32(barlen, 0);

                    // get the name
                    bardt = new byte[len];
                    Array.Copy(dt, idx, bardt, 0, len);
                    idx += len;
                    string tbname = Encoding.ASCII.GetString(bardt);

                    // get the length of the value
                    Array.Copy(dt, idx, barlen, 0, NUMLEN);
                    idx += NUMLEN;
                    len = BitConverter.ToInt32(barlen, 0);

                    // get the value
                    bardt = new byte[len];
                    Array.Copy(dt, idx, bardt, 0, len);
                    idx += len;
                    ParamObject tbvalue = new ParamObject();
                    tbvalue.FromByteArray(bardt);

                    tbparam.Add(tbname, tbvalue);
                }
            }
        }
        XMLParser m_xmlParser;
        Architecture m_arch;

        private bool m_bInitialized;
        private bool m_bStarted;
        private string m_xmlFile;
        #endregion

        #region constructors and public variables
        public MassWare()
        {
            m_xmlFile = "dc.xml";
            m_bInitialized = false;
            m_bStarted = false;

            m_xmlParser = new XMLParser(m_xmlFile);
            m_arch = new Architecture();
        }
        public MassWare(string xmlfile)
        {
            m_xmlFile = xmlfile;
            m_bInitialized = false;
            m_bStarted = false;

            m_xmlParser = new XMLParser(m_xmlFile);
            m_arch = new Architecture();
        }

        public void SetXmlFile(string xmlfile)
        {
            m_xmlFile = xmlfile;
            m_xmlParser.SetXmlFile(m_xmlFile);
        }

        public void SetAppParameter(string name, string func, object[] paramlist)
        {
            m_arch.SetAppParameter(name, func, paramlist);
        }

        public bool IsStarted
        {
            get
            {
                return m_bStarted;
            }
        }

        #endregion

        #region functions
        public bool Start()
        {
            if (m_bStarted) return true;
            if (!m_bInitialized) Initialize();
            m_arch.StartAppChain();
            m_arch.StartMassTools();
            m_bStarted = true;
            return true;
        }

        public bool Stop()
        {
            if (!m_bStarted) return true;

            m_arch.StopMassTools();
            m_arch.StopAppChain();
            m_bStarted = false;
            return true;
        }

        public bool Initialize()
        {
            if (m_bInitialized) return true;
            m_xmlParser.SetArch(m_arch);
            m_xmlParser.Start();
            m_arch.Initialize();
            m_bInitialized = true;
            return true;
        }

        public bool SyncTo(IPAddress ep)
        {
            m_arch.SyncTo(ep);
            return true;
        }

        public bool Dispose()
        {
            Stop();
            m_xmlParser.Dispose();
            m_arch.Dispose();
            return true;
        }

        public void AddArchSubscriber(Architecture.MassWareArchChangeEventHandler handler)
        {
            m_arch.ArchChangeEvent += handler;
        }
/*      
        public void GetFormatValue(char *);
        public void SetHWnd(CWnd *pWnd);
	        
        public bool Start();
        public bool Stop();
        
        public void SetAppParam(char*, char*, void * value  = (void *)1);
        public void SetAdaptation(bool b = true);
*/
        #endregion

    }
}