/**
 * Copyright (c) 2009 - Lehigh University. Bethlehem, PA, USA.
 * All rights reserved.
 * This source code is a part of MARCHES Project. 
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs, and the author attribution appear in all copies of this
 * software.
 *
 * IN NO EVENT SHALL LEHIGH UNIVERSITY BE LIABLE TO ANY PARTY FOR DIRECT, 
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF LEHIGH
 * UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *	
 * LEHIGH UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, 
 * AND LEHIGH UNIVERSITY HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 **/

// modsDlg.cpp : implementation file
//

using System;
using System.Collections.Generic;
using System.Text;
using MassTools;

namespace MassWare
{
    public class EventComp : EventBC //internal, public for X.doc generation
    {
        #region vairables and constructors
        
        // Delegate instance for the children callback - must keep alive! gc should NOT collect it
        private MassToolDataReadyEventHandler mLeftEventHandler, mRightEventHandler; // for tool children
        private double m_dLeft, m_dRight; 

        public EventComp()
        {
        }
        #endregion

        #region event and call back functions
        public MassToolDataReadyEventHandler GetListener(SIDETYPE t)
        {
            switch (t)
            {
                case SIDETYPE.SD_LEFT:
                    if (mLeftEventHandler == null)
                        mLeftEventHandler = new MassToolDataReadyEventHandler(LeftDataReceiveCallBack);
                    return mLeftEventHandler;
                case SIDETYPE.SD_RIGHT:
                    if (mRightEventHandler == null)
                        mRightEventHandler = new MassToolDataReadyEventHandler(RightDataReceiveCallBack);
                    return mRightEventHandler;
                default:
                    return null;
            }
        }

        public void LeftDataReceiveCallBack(object sender, MassToolEventArgs e)
        {
            m_dLeft = e.mValue;
            CalResult();
            NotifySubScribers();
        }

        public void RightDataReceiveCallBack(object sender, MassToolEventArgs e)
        {
            m_dRight = e.mValue;
            CalResult();
            NotifySubScribers();
        }
        #endregion

        #region parameter setting functions
        public double mLeftValue
        {
            get
            {
                return m_dLeft;
            }
            set
            {
                m_dLeft = value;
                CalResult();
            }
        }

        public double mRightValue
        {
            get
            {
                return m_dRight;
            }
            set
            {
                m_dRight = value;
                CalResult();
            }
        }

        public override bool IsValue()
        {
            if (mLeftEventHandler != null || mRightEventHandler != null)
                return false;
            return true;
        }

        public override void CalResult()
        {
            switch (opType)
            {
                case OPTYPE.GT:
                    m_bValue = (m_dLeft > m_dRight);
                    break;
                case OPTYPE.GE:
                    m_bValue = (m_dLeft >= m_dRight);
                    break;
                case OPTYPE.EQ:
                    m_bValue = (m_dLeft == m_dRight);
                    break;
                case OPTYPE.LT:
                    m_bValue = (m_dLeft < m_dRight);
                    break;
                case OPTYPE.LE:
                    m_bValue = (m_dLeft <= m_dRight);
                    break;
            }
        }
        #endregion

        #region create comparision events
        public static string CreateKey(EventExpr left, EventExpr right, string type)
        {
            return left.mPositiveTag + type + right.mPositiveTag;
        }
        public static EventComp MergeEvents(EventExpr left, EventExpr right, string type)
        {
            EventComp result = new EventComp();
            result.SetOPType(type);
            result.mPositiveTag = CreateKey(left, right, type);

            if (left.IsValue()) result.mLeftValue = left.mValue;
            else left.AddSubscriber(result.GetListener(SIDETYPE.SD_LEFT));

            if (right.IsValue()) result.mRightValue = right.mValue;
            else right.AddSubscriber(result.GetListener(SIDETYPE.SD_RIGHT));

            return result;
        }
        #endregion

    }
}
