/**
 * Copyright (c) 2009 - Lehigh University. Bethlehem, PA, USA.
 * All rights reserved.
 * This source code is a part of MARCHES Project. 
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs, and the author attribution appear in all copies of this
 * software.
 *
 * IN NO EVENT SHALL LEHIGH UNIVERSITY BE LIABLE TO ANY PARTY FOR DIRECT, 
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF LEHIGH
 * UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *	
 * LEHIGH UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, 
 * AND LEHIGH UNIVERSITY HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 **/

// modsDlg.cpp : implementation file
//

using System;
using System.Collections.Generic;
using System.Text;
using MassTools;

namespace MassWare
{
    public class EventBool : EventBC //internal, public for X.doc generation
    {
        #region vairables and constructors

        // Delegate instance for the children callback - must keep alive! gc should NOT collect it
        private EventHandler mLeftEventHandler, mRightEventHandler; // for branch children
        private bool m_dLeft, m_dRight;

        public EventBool()
        {
        }
        #endregion

        #region event and call back functions

        public EventHandler GetListener(SIDETYPE t)
        {
            switch (t)
            {
                case SIDETYPE.SD_LEFT:
                    if (mLeftEventHandler == null)
                        mLeftEventHandler = new EventHandler(LeftDataReceiveCallBack);
                    return mLeftEventHandler;
                case SIDETYPE.SD_RIGHT:
                    if (mRightEventHandler == null)
                        mRightEventHandler = new EventHandler(RightDataReceiveCallBack);
                    return mRightEventHandler;
                default:
                    return null;
            }
        }

        public void LeftDataReceiveCallBack(object sender, EventArgs e)
        {
            m_dLeft = true;
            CalResult();
            NotifySubScribers();
        }

        public void RightDataReceiveCallBack(object sender, EventArgs e)
        {
            m_dRight = true;
            CalResult();
            NotifySubScribers();
        }
        #endregion

        #region parameter setting functions

        public bool mLeftValue
        {
            get
            {
                return m_dLeft;
            }
            set
            {
                m_dLeft = value;
                CalResult();
            }
        }

        public bool mRightValue
        {
            get
            {
                return m_dRight;
            }
            set
            {
                m_dRight = value;
                CalResult();
            }
        }

        public override bool IsValue()
        {
            if (mLeftEventHandler != null || mRightEventHandler != null)
                return false;
            return true;
        }

        public override void CalResult()
        {
            switch (opType)
            {
                case OPTYPE.AND:
                    m_bValue = (m_dLeft && m_dRight);
                    break;
                case OPTYPE.OR:
                    m_bValue = (m_dLeft || m_dRight);
                    break;
            }
        }
        #endregion

        #region create boolean events
        public static string CreateKey(EventBC left, EventBC right, string type)
        {
            return left.mPositiveTag + type + right.mPositiveTag;
        }

        public static EventBool MergeEvents(EventBC left, EventBC right, string type)
        {
            EventBool result = new EventBool();
            result.SetOPType(type);
            result.mPositiveTag = CreateKey(left, right, type);

            if (left.IsValue()) result.mLeftValue = left.mValue;
            else left.AddSubscriber(result.GetListener(SIDETYPE.SD_LEFT));

            if (right.IsValue()) result.mRightValue = right.mValue;
            else right.AddSubscriber(result.GetListener(SIDETYPE.SD_RIGHT));

            return result;
        }

        #endregion

    }
}
