/**
 * Copyright (c) 2009 - Lehigh University. Bethlehem, PA, USA.
 * All rights reserved.
 * This source code is a part of MARCHES Project. 
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs, and the author attribution appear in all copies of this
 * software.
 *
 * IN NO EVENT SHALL LEHIGH UNIVERSITY BE LIABLE TO ANY PARTY FOR DIRECT, 
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF LEHIGH
 * UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *	
 * LEHIGH UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, 
 * AND LEHIGH UNIVERSITY HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 **/

// modsDlg.cpp : implementation file
//

using System;
using System.Collections.Generic;
using System.Text;

namespace MassWare
{
    public class EventBC
    {
        public enum OPTYPE { AND = 0, OR, GT, GE, EQ, LT, LE, ERROR}
        public enum SIDETYPE { SD_LEFT = 0, SD_RIGHT };

        // Delegate instance for notifying to subscribers
        // because branch node only notifiy the subscribers when it is true, so it does not need to take data
        public event EventHandler EventDataReadyEvent;

        protected bool m_bValue;
        protected string m_posTag, m_negTag;
        protected OPTYPE opType;   // the operation type.

        private int m_nIdx; // used to identify differnt events based on different actuators

        public EventBC()
        {

        }

        public void AddSubscriber(EventHandler handler)
        {
            EventDataReadyEvent += handler;
        }

        public void NotifySubScribers()
        {
            if (EventDataReadyEvent != null && m_bValue)
                EventDataReadyEvent(this, new EventArgs());
        }

        static public OPTYPE ParseType(string ptp)
        {
            OPTYPE type = OPTYPE.ERROR;
            string tp = ptp.Trim().ToUpper();

            if ("AND" == tp) type = OPTYPE.AND;
            else if ("OR" == tp) type = OPTYPE.OR;
            else if ("GT" == tp) type = OPTYPE.GT;
            else if ("GE" == tp) type = OPTYPE.GE;
            else if ("EQ" == tp) type = OPTYPE.EQ;
            else if ("LT" == tp) type = OPTYPE.LT;
            else if ("LE" == tp) type = OPTYPE.LE;
            
            return type;
        }

        public void SetOPType(string ptp)
        {
            opType = ParseType(ptp);
        }

        public OPTYPE mOPType
        {
            get
            {
                return opType;
            }
            set
            {
                opType = value;
            }
        }

        public string mPositiveTag
        {
            get
            {
                return m_posTag;
            }
            set
            {
                m_posTag = value;
            }
        }

        public int mIndex
        {
            get
            {
                return m_nIdx;
            }
            set
            {
                m_nIdx = value;
            }
        }

        public string mNegativeTag
        {
            get
            {
                return m_negTag;
            }
            set
            {
                m_negTag = value;
            }
        }

        public bool mValue
        {
            get
            {
                return m_bValue;
            }
        }

        public virtual bool IsValue() { return false; }

        public virtual void CalResult() { }
    }
}
