/**
 * Copyright (c) 2009 - Lehigh University. Bethlehem, PA, USA.
 * All rights reserved.
 * This source code is a part of MARCHES Project. 
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs, and the author attribution appear in all copies of this
 * software.
 *
 * IN NO EVENT SHALL LEHIGH UNIVERSITY BE LIABLE TO ANY PARTY FOR DIRECT, 
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF LEHIGH
 * UNIVERSITY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *	
 * LEHIGH UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, 
 * AND LEHIGH UNIVERSITY HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 **/

// modsDlg.cpp : implementation file
//

using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.Net.Sockets;
using System.Collections;
using Masslets;
using System.Reflection;

namespace MassWare
{
    public class Actuator
    {
        public const string SOCKET_INTERFACE = "Socket",
            APPLICATION_INTERFACE = "Application",
            START_INTERFACE = "Start";

        public enum SYNCTYPE { Sync = 0, Async };
        public struct AMDestination
        {
            public IPAddress endPoint;
            public byte activeHeader;
        }

        List<MassWare.MassletReflectObject> mCompntList;
        SYNCTYPE m_syncType;

        UDPClient m_udpSender;

        List<AMDestination> m_listDests;

        public string mStructure; // show the current structure
        // how to accept application and socket input
        public MassletDataReadyEventHandler SocketDataReadyHandler, AppDataReadyHandler;

        public Actuator()
        {
            mCompntList = new List<MassWare.MassletReflectObject>();
            m_listDests = new List<AMDestination>();
            SocketDataReadyHandler = new MassletDataReadyEventHandler(SocketDataReadyCallBack);
            AppDataReadyHandler = new MassletDataReadyEventHandler(AppDataReadyCallBack);
        }

        #region parameter set by xml parser
        public void SetSyncType(string tp)
        {
            if (tp.Trim() == "Sync") m_syncType = SYNCTYPE.Sync;
            else if (tp.Trim() == "Async") m_syncType = SYNCTYPE.Async;
        }
        public SYNCTYPE mSyncType
        {
            get
            {
                return m_syncType;
            }
            set
            {
                m_syncType = value;
            }
        }
        public void AddMasslet(MassWare.MassletReflectObject rfob)
        {
            mCompntList.Add(rfob);
        }
        public List<MassWare.MassletReflectObject> mActuator
        {
            get
            {
                return mCompntList;
            }
            set
            {
                mCompntList = value;
            }
        }
        #endregion


        #region parameter set by architecture
        public UDPClient mUdpClient
        {
            get
            {
                return m_udpSender;
            }
            set
            {
                m_udpSender = value;
            }
        }

        public void AddDestination(IPAddress ep, byte type)
        {
            AMDestination dest;
            dest.endPoint = ep;
            dest.activeHeader = type;
            m_listDests.Add(dest);
        }

        // used for reactive actuators
        public AMDestination GetFirstDestination()
        {
            return m_listDests[0];
        }

        public void RemoveDestination(IPAddress ep)
        {
            for (int i = 0; i < m_listDests.Count; i++)
            {
                AMDestination dest = m_listDests[i];
                if (dest.endPoint.Equals(ep))
                {
                    m_listDests.RemoveAt(i);
                    i--;
                }
            }
        }
        #endregion


        #region manipunation functions
        // for active actuator to process data
        public bool Start(bool bInitial)
        {
            // InitialConnection
            InitializeConnection(true);
            InitializeParameter();
            if (bInitial)
                StartMasslets();

            return true;
        }

        public bool Stop(bool bfinal)
        {
            // destory previous constructed connections
            InitializeConnection(false);
            if (bfinal)
                StopMasslets();
            return true;
        }

        // bconnect = true, connect all components
        // bconnect = false, disconnect all components
        public void InitializeConnection(bool bConnect)
        {
            List<string> formatstrl = new List<string>();

            foreach (MassWare.MassletReflectObject rfSend in mCompntList)
            {
                // just for display
                if (!formatstrl.Contains(getLastName(rfSend.name)))
                    formatstrl.Add(getLastName(rfSend.name));
                // end display

                IDictionaryEnumerator _enumerator = rfSend.tbOutput.GetEnumerator();
                while (_enumerator.MoveNext())
                {
                    MassWare.Connector conSend = (MassWare.Connector)_enumerator.Value;
                    if ((string)_enumerator.Key == SOCKET_INTERFACE)
                    {
                        Type typeInterface = rfSend.type.GetInterface(conSend.interf);
                        object[] paramReg = { SocketDataReadyHandler, bConnect };
                        typeInterface.InvokeMember(
                             conSend.func,
                             BindingFlags.InvokeMethod,  // how to bind
                             null,                       // binder
                             rfSend.obj,                 // the COM object
                             paramReg);                  // the method arguments
                    }
                    else if ((string)_enumerator.Key == APPLICATION_INTERFACE)
                    {
                        Type typeInterface = rfSend.type.GetInterface(conSend.interf);
                        object[] paramReg = { AppDataReadyHandler, bConnect };
                        typeInterface.InvokeMember(
                             conSend.func,
                             BindingFlags.InvokeMethod,  // how to bind
                             null,                       // binder
                             rfSend.obj,                 // the COM object
                             paramReg);                  // the method arguments
                    }
                    else
                    {
                        MassWare.MassletReflectObject rfRecv = new MassWare.MassletReflectObject();
                        MassWare.Connector conRecv = new MassWare.Connector();
                        for (int i = 0; i < mCompntList.Count; i++)
                        {
                            if (mCompntList[i].name == (string)_enumerator.Key)
                            {
                                rfRecv = mCompntList[i];
                                IDictionaryEnumerator _enumerator2 = rfRecv.tbInput.GetEnumerator();
                                while (_enumerator2.MoveNext())
                                {
                                    if (rfSend.name == (string)_enumerator2.Key)
                                    {
                                        conRecv = (MassWare.Connector)_enumerator2.Value;
                                        break;
                                    }
                                }
                                break;
                            }
                        }
                        Type typeInterface = rfRecv.type.GetInterface(conRecv.interf);
                        object[] paramReg = {typeInterface.InvokeMember(
                            conRecv.func,
                            BindingFlags.InvokeMethod,  // how to bind
                            null,                       // binder
                            rfRecv.obj,                 // the COM object
                            null),                      // the method arguments
                            bConnect
                        };

                        typeInterface = rfSend.type.GetInterface(conSend.interf);
                        typeInterface.InvokeMember(
                             conSend.func,
                             BindingFlags.InvokeMethod,  // how to bind
                             null,                       // binder
                             rfSend.obj,                 // the COM object
                             paramReg);                  // the method arguments


                        ////////////////////////set the format string list, just for display
                        if (!formatstrl.Contains(getLastName(rfRecv.name)))
                            formatstrl.Add(getLastName(rfRecv.name));
                        /////////////////////////////just for display
                    }
                }
            }

            // just for display
            mStructure = formatstrl[0];
            for (int i = 1; i < formatstrl.Count; i++) mStructure += " -> " + formatstrl[i];
            mStructure += '$';
            // end display
        }

        public void InitializeParameter()
        {
            foreach (MassWare.MassletReflectObject rfpob in mCompntList)
            {
                IDictionaryEnumerator _enumerator = rfpob.tbparam.GetEnumerator();
                while (_enumerator.MoveNext())
                {
                    MassWare.ParamObject param = (MassWare.ParamObject)_enumerator.Value;
                    Type t = Type.GetType(XMLParser.strTypeHeader + param.type);
                    Object[] p = { Convert.ChangeType(param.value, t) };

                    rfpob.type.InvokeMember((string)_enumerator.Key, BindingFlags.InvokeMethod, null, rfpob.obj, p);

                    mStructure += "  " + (string)_enumerator.Key + ": " + param.value;
                }
            }
        }

        public void StartMasslets()
        {
            foreach (MassWare.MassletReflectObject rfIn in mCompntList)
            {
                IDictionaryEnumerator _enumerator = rfIn.tbInput.GetEnumerator();
                while (_enumerator.MoveNext())
                {
                    if ((string)_enumerator.Key == START_INTERFACE)
                    {
                        MassWare.Connector conIn = (MassWare.Connector)_enumerator.Value;
                        // start the application
                        rfIn.type.InvokeMember(
                            conIn.func, // start functions
                            BindingFlags.InvokeMethod,
                            null,
                            rfIn.obj,
                            null);
                    }
                }
            }
        }

        public void StopMasslets()
        {
            foreach (MassWare.MassletReflectObject rfIn in mCompntList)
            {
                IDictionaryEnumerator _enumerator = rfIn.tbInput.GetEnumerator();
                while (_enumerator.MoveNext())
                {
                    if ((string)_enumerator.Key == START_INTERFACE)
                    {
                        MassWare.Connector conIn = (MassWare.Connector)_enumerator.Value;
                        // start the application
                        rfIn.type.InvokeMember(
                            conIn.interf, // stop functions
                            BindingFlags.InvokeMethod,
                            null,
                            rfIn.obj,
                            null);
                    }
                }
            }
        }

        #endregion

        #region input and output call back functions
        public void SocketDataReadyCallBack(object sender, MassletEventArgs e)
        {
            foreach (AMDestination dest in m_listDests)
                m_udpSender.Send(dest.activeHeader, e.mData, dest.endPoint);
        }

        public void AppDataReadyCallBack(object sender, MassletEventArgs e)
        {
        }

        public MassletDataReadyEventHandler[] GetSocketEventHandler()
        {
            List<MassletDataReadyEventHandler> list = new List<MassletDataReadyEventHandler>();
            foreach (MassWare.MassletReflectObject rfob in mCompntList)
            {
                if (rfob.tbInput.ContainsKey(SOCKET_INTERFACE))
                {
                    Type typeInterface = rfob.type.GetInterface(((MassWare.Connector)rfob.tbInput[SOCKET_INTERFACE]).interf);
                    list.Add((MassletDataReadyEventHandler)typeInterface.InvokeMember(
                        ((MassWare.Connector)rfob.tbInput[SOCKET_INTERFACE]).func,
                        BindingFlags.InvokeMethod,  // how to bind
                        null,                       // binder
                        rfob.obj,                 // the COM object
                        null));                    // the method arguments
                }
            }
            return list.ToArray();
        }

        public MassletDataReadyEventHandler[] GetAppEventHandler()
        {
            return null;
        }

        #endregion

        public string getLastName(string orgstr)
        {
            string[] arStr = orgstr.Split('.');
            return arStr[arStr.Length - 1];
        }
    }
}
